using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{



		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///VBECS Progress bar
		///</summary>

		#endregion


	public class VbecsProgressBar : System.Windows.Forms.Control
	{
		private Timer _timer;
        private Color _colorFixed;
        private Color _colorFade;
        private float _position;
        private float _step;
        //

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// VbecsProgressBar class constructor
		/// </summary>
		public VbecsProgressBar()
        {
            //
            this.SetStyle(ControlStyles.UserPaint,true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint,true);
            this.SetStyle(ControlStyles.DoubleBuffer,true);
            //
            _colorFixed = Color.FromKnownColor(KnownColor.AliceBlue);
			_colorFade = Color.FromKnownColor(KnownColor.ActiveCaption);
			_position = this.Width;
			_step = 3;
            //
		}
        //

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// On paint event handler
		/// </summary>
		/// <param name="pe">Paint event args</param>
		protected override void OnPaint(PaintEventArgs pe)
		{
			LinearGradientBrush gradBrush = new LinearGradientBrush(this.Bounds, 
                _colorFixed, 
                _colorFade, 
                0, 
                false);
			gradBrush.WrapMode = WrapMode.TileFlipX;
			gradBrush.TranslateTransform(_position, 0, MatrixOrder.Append);
			pe.Graphics.FillRectangle(gradBrush, 0, 0, this.Width, this.Height);      
			gradBrush.Dispose();
			base.OnPaint(pe);
		}
        //

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// On tick event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="args">Event args</param>
		public void OnTick(object sender, EventArgs args) 
		{    
			_position += _step;
            if (_position > this.Width) 
            {
                _position = -this.Width;
            }
			this.Invalidate();
		}
        //

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// On visible changed event handler
		/// </summary>
		/// <param name="e">Event args</param>
		protected override void OnVisibleChanged(EventArgs e)
		{
			if (this.Visible) 
			{
				if (_timer == null) 
				{
					_timer = new System.Windows.Forms.Timer();
					_timer.Interval = 20;
					_timer.Tick += new EventHandler(OnTick);          
				}
				_timer.Start();
			} 
			else 
			{
				if (_timer != null) 
				{
					_timer.Stop();
				}
			}
			base.OnVisibleChanged(e);
		}
        //

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Gets or sets fixed color
		/// </summary>
        public Color ColorFixed
        {
            get 
            {
                return _colorFixed;
            }
            set 
            {
                _colorFixed = value;
            }
        }
        //

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Gets or sets fade color
		/// </summary>
        public Color ColorFade
        {
            get 
            {
                return _colorFade;
            }
            set 
            {
                _colorFade = value;
            }
        }
        //

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Gets or sets position
		/// </summary>
        public float Position
        {
            get
            {
                return _position;
            }
            set
            {
                _position = value;
            }
        }
        //

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Gets or sets step
		/// </summary>
        public float Step
        {
            get
            {
                return _step;
            }
            set
            {
                _step = value;
            }
        }
    }
}
